#ifndef __SECUPASS_AUTH_H__
#define __SECUPASS_AUTH_H__

#ifndef NULL
#define NULL 0
#endif
//
#ifdef __cplusplus
extern "C" {
#endif
#define		MAX_HOSTLEN					20		//max length of IP(*.*.*.*formate)
#define		MAX_SHARELEN				20		//share secret length
#define		MAX_PWDLEN					128		//max length of password
#define		MAX_PACKETLEN				512		//max length of request package
#define		RD_ERROR_SUCCESS			0		//success
#define		RD_ERROR_INVALID_USERNAME	-1		//invalid username
#define		RD_ERROR_INVALID_PWD		-2		//error password
#define		RD_ERROR_INVALIDHOST		-3		//invalid authentication host
#define		RD_ERROR_INVALIDPCNAME		-4		//get computer name failed
#define		RD_ERROR_GENRAFAILED		-5		//generate request authenticator failed
#define		RD_ERROR_GENPWDFAILED		-6		//encrypt password failed
#define		RD_ERROR_CREATEPKTFAILED	-7		//generate authentication package failed
#define		RD_ERROR_CREATESOCKETFAILED -8		//initialize socket failed
#define		RD_ERROR_SENDDATAFAILED		-9		//send data (through socket) failed
#define		RD_ERROR_RECVDATAFAILED		-10		//receive data failed
#define		RD_ERROR_INVALIDPKT			-11		//invlaid package
#define		RD_ERROR_NORESPONSE			-12		//no response from authentication server
#define		RD_ERROR_AUTHFAILED			-13		//authentication failed
#define		RD_ERROR_GETCHALLENGEFAILED -14		//get challenge number failed
#define     RD_ERROR_REMOTESOCKETCLOSED -15		//remote socket closed
#define     RD_ERROR_INITSOCKFAILED		-16		//function wsastartup failed
	
#define		RD_ERROR_CHALLENGENEED		1		//challenge need
	
	

//////////////////////////////////////////////////////////
#define		RD_REQUESTCODE_AUTH		1		//access request
#define		RD_REQUESTCODE_ACCEPT	2		//authentication successfully
#define		RD_REQUESTCODE_REJECT	3		//access denied(password error)
#define		RD_REQUESTCODE_CHALLENGE 11		//get a challenge from the authentication server
	
#ifndef NULL
#define NULL 0
#endif
/************************************************************************/
/* function: secuauth (OTP Authentication Interface)
/* params  : char *phost -- authentication server
/*			 char *pshare -- share key between authentication server and the client
/*			 int nsharelen -- length of the share key
/*			 char *pszusername -- username to be authenticated
/*			 int nusernamelen -- length of the username
/*			 char *pszpassword -- password for authentication (OTP/OTP+PIN)
/*			 int npasswordlen -- length og the password
/*			 int *pnchallenge -- receive the challenge
/*			 int *pbvalidresponse -- weather get response message
/*			 char *presponse -- buffer to save the response message
/*			 int nmaxbuflen -- the max length of the response buffer
/*			 unsigned short uport -- port of the authentication service
/*			 int nwaittime -- max waite time for the server response	
/************************************************************************/

int secuauth(char *phost, char *pshare, int nsharelen, char *pszusername, int nusernamelen, 
			 char *pszpassword, int npasswordlen, int *pnchallenge, int *pbvalidresponse,
			 char *presponse/* = NULL*/, int nmaxbuflen/* = 0*/,
			 unsigned short uport/* = 1812*/, int nwaittime/* = 3*/);

//extern "C"
#ifdef __cplusplus
}
#endif
#endif